package com.qiho.center.api.enums.item;

import com.qiho.center.api.exception.QihoException;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * @author Wangpf
 * @date 2023/10/16 14:15
 */
public enum ItemDynamicRegionEnum {

    /**
     * 投放地域-省
     */
    PROVINCE(1),

    /**
     * 投放地域-市
     */
    CITY(2)

    ;


    private final int code;

    ItemDynamicRegionEnum(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public static void checkCode(Integer code){
        Optional<Integer> any = Arrays.stream(ItemDynamicRegionEnum.values()).map(ItemDynamicRegionEnum::getCode).filter(
                tmpCode -> Objects.equals(code, tmpCode)
        ).findAny();

        if (!any.isPresent()){
            throw new QihoException("动态地域选择错误");
        }
    }
}
