package com.qiho.center.api.enums.order;


/**
 * @author Wangpf
 * @description
 * @date 2020/5/15 10:58 上午
 */
public enum ManualOperationTypeEnum {

    /**
     * 文件上传的第一种的类型
     */
    FIRST_KIND(1,"订单ID,订单状态,物流公司,物流单号,备注"),

    /**
     * 第二中类型
     */
    SECOND_KIND(2,"下单日期,商品ID,手机号,订单状态,物流公司,物流单号,备注"),

    /**
     * 文件上传的第一种的类型
     */
    FIRST_KIND_BACKUP(3,"订单ID,物流公司,物流单号,备注"),

    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 表头
     */
    private final String headers;

    ManualOperationTypeEnum(Integer type, String headers) {
        this.type = type;
        this.headers = headers;
    }

    public Integer getType() {
        return type;
    }

    public String getHeaders() {
        return headers;
    }

    /**
     * fail-fast
     *
     * @param type 表头类型
     * @return
     */
    public static String[] getHeaders(Integer type) {
        for (ManualOperationTypeEnum value : ManualOperationTypeEnum.values()) {
            if (value.getType().equals(type)) {
                return value.getHeaders().split(",");
            }
        }
        throw new IllegalArgumentException("The type " + type + " is illegal");
    }
}
