package com.qiho.center.api.params.needsync.cancelledorder;

import com.qiho.center.api.exception.QihoException;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * { 登记 } 取消订单·信息
 * @dateTime 2020-08-05 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class EnrolmentCancelledOrderParams implements Serializable {


    /**
     * 订单·订单号
     */
    private String orderId;

    /**
     * 订单·手机号
     */
    private String orderMobile;

    /**
     * 订单·创建时间
     */
    private Date orderCreateTime;

    /**
     * 商家·Id
     */
    private Long merchantId;


    public EnrolmentCancelledOrderParams checkEnrolment() {
        if (StringUtils.isBlank(orderId)) {
            throw new QihoException("{ 信息·缺失 } 订单·订单号缺失!!!. ");
        }
        if (StringUtils.isBlank(orderMobile)) {
            throw new QihoException("{ 信息·缺失 } 订单·手机号缺失!!!. ");
        }
        if (Objects.isNull(orderCreateTime)) {
            throw new QihoException("{ 信息·缺失 } 订单·创建时间缺失!!!. ");
        }
        if (Objects.isNull(merchantId)) {
            throw new QihoException("{ 信息·缺失 } 商家 Id 缺失!!!. ");
        }
        return this;
    }

}