package com.qiho.center.api.remoteservice.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.order.OrderWinDTO;
import com.qiho.center.api.params.ordertmp.OrderWinPageParam;

/**
 * @author Wangpf
 * @date 2023/12/5 16:24
 */
@AdvancedFeignClient
public interface RemoteOrderWinService {

    /**
     * 保存中奖记录
     *
     * @param orderWinDTO
     * @return
     */
    boolean save(OrderWinDTO orderWinDTO);

    /**
     * 更新中奖记录
     *
     * @param orderWinDTO
     * @return
     */
    boolean update(OrderWinDTO orderWinDTO);

    /**
     * 分页查询中奖记录
     *
     * @param orderWinPageParam
     * @return
     */
    PagenationDto<OrderWinDTO> page(OrderWinPageParam orderWinPageParam);
}
