package com.qiho.center.api.remoteservice.page;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.page.BaiqiPageDto;
import com.qiho.center.api.dto.page.CollPageDto;
import com.qiho.center.api.params.CollItemListQueryParam;

import java.util.List;

/**
 * 集合页页面后台服务
 *
 * @author jiafeng.geng
 * @date 2018-07-19.
 */
@AdvancedFeignClient
public interface RemoteCollPageBackendService {
    /**
     * 查询集合页列表，不分页查询的重载类
     * @return 集合页列表
     */
    List<CollPageDto> queryList();

    /**
     * 查询集合页列表
     * @param pageNum 查询页数
     * @param pageSize 每页数量
     * @return List<CollPageVO>
     */
    PagenationDto<CollPageDto> queryListWithPaging(Integer pageNum, Integer pageSize);

    /**
     * 查询页面模板列表
     *
     * @param pageType 页面类型, 1-商品详情页/2-商品集合页
     * @return List<BaiqiPageDto>
     */
    List<BaiqiPageDto> querySkinList(Integer pageType);

    /**
     * 新增页面模板
     *
     * @param collPageDto
     * @return Integer
     */
    Integer addCollPage(CollPageDto collPageDto);

    /**
     * 编辑页面模板
     *
     * @param collPageDto
     * @return Integer
     */
    Integer updateCollPage(CollPageDto collPageDto);

    /**
     * 查询商品信息
     *
     * @param params
     * @return List<ItemDto>
     */
    List<ItemDto> queryCollItemIndex(CollItemListQueryParam params);

    /**
     * 根据集合页id查询页面数据
     * @param id
     * @return
     */
    CollPageDto findById(Long id);
}
