package com.qiho.center.api.enums.discount;

import java.util.stream.Stream;

/**
 * 优惠的类型
 * e.g.减金额、打折
 *
 * @author chensong
 * @create 2018-09-04
 */
public enum DiscountTypeEnum {

    /** 减订单金额 */
    REDUCE_AMT(1, "REDUCE_AMT", "减金额"),

    /** 订单金额打折 */
    REBATE(2, "REBATE", "打折扣")
    ;

    private Integer value;

    private String code;

    private String desc;

    private DiscountTypeEnum(Integer value, String code, String desc) {
        this.value = value;
        this.code = code;
        this.desc = desc;
    }

    public Integer getValue() {
        return value;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据数值获取
     * @param value
     * @return
     */
    public static DiscountTypeEnum getByValue(Integer value){
        if (value == null) {
            return null;
        }
        return Stream.of(DiscountTypeEnum.values())
                .filter(e -> e.getValue().equals(value)).findFirst().orElse(null);
    }

}
