package com.qiho.center.api.enums.finance;

import org.apache.commons.lang3.StringUtils;

/**
 * Created by xianhongwei on 2017/12/26.
 */
public enum FinanceStatusEnum {

    NORMAL(0,"NORMAL","正常"),
    FREEZE(1,"FREEZE","冻结");
    /** 代码 */
    private Integer code;

    /**
     * 状态
     */
    private String state;

    /** 描述 */
    private String desc;



    FinanceStatusEnum(Integer code, String state, String desc) {
        this.code = code;
        this.state = state;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getState() {
        return state;
    }

    public String getDesc() {
        return desc;
    }

    public static FinanceStatusEnum getByState(String state){
        for (FinanceStatusEnum value : FinanceStatusEnum.values() ) {
            if (StringUtils.equals(value.getState(), state)) {
                return value;
            }
        }
        return null;
    }

    public static FinanceStatusEnum getByCode(int code){
        for (FinanceStatusEnum value : FinanceStatusEnum.values()) {
            if (value.getCode() == code) {
                return value;
            }
        }
        return null;
    }
}
