package com.qiho.center.api.remoteservice.campaign;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.campaign.MediaPlanDto;
import com.qiho.center.api.params.MediaPlanParams;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by danke on 2017/6/16.
 * 媒体计划暴露服务接口
 */
@AdvancedFeignClient
public interface RemoteMediaPlanService {

    /**
     * 分页查询
     */
    DubboResult<PagenationDto<MediaPlanDto>> queryMediaPlanByPage(MediaPlanParams params, Integer pageNum,
        Integer pageSize);

    /**
     * 通过id删除
     */
    DubboResult<Boolean> deleteMediaPlanById(Long id, String gmtModifier);

    /**
     * 更新
     */
    DubboResult<Boolean> updateMediaPlanByParam(MediaPlanDto mediaPlanDto);

    /**
     * 插入
     */
    DubboResult<Integer> insertMediaPlan(MediaPlanDto mediaPlanDto);

    /**
     * 条件查询总记录数
     */
    DubboResult<Integer> countByParam(MediaPlanParams params);
}
