package com.qiho.center.api.remoteservice.item;

import java.util.List;

import com.qiho.center.api.dto.item.ItemEvaluateDto;
import com.qiho.center.api.params.item.BatchImportItemEvaluateParams;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 商品评价后台服务
 *
 * @author jiafeng.geng
 * @date 2018-8-21.
 */
@AdvancedFeignClient
public interface RemoteItemEvaluateBackendService {

    /**
     * 查询商品下的评价列表
     *
     * @param itemId 商品id
     * @return List<ItemEvaluateVO>
     */
    List<ItemEvaluateDto> queryItmeEvalList(Long itemId);

    /**
     * 查询商品下的评价总数
     *
     * @param itemId 商品id
     * @return Integer
     */
    Integer queryItemEvalCount(Long itemId);

    /**
     * 查询商品下的最大排序值
     *
     * @param itemId 商品id
     * @return Integer
     */
    Integer queryMaxSort(Long itemId);

    /**
     * 新增商品评价
     *
     * @param itemEvaluateDto
     * @return Integer
     */
    Integer addItemEval(ItemEvaluateDto itemEvaluateDto);

    /**
     * 编辑商品评价
     *
     * @param itemEvaluateDto
     * @return Integer
     */
    Integer updateItemEval(ItemEvaluateDto itemEvaluateDto);

    /**
     * 删除商品评价
     *
     * @param itemEvalId 商品评价id
     * @return Integer
     */
    Integer deletedItemEval(Long itemEvalId);

    /**
     * 排序商品评价
     *
     * @param itemId      商品id
     * @param itemEvalIds 商品评价id列表
     * @return Integer
     */
    Integer sortItemEval(Long itemId, List<Long> itemEvalIds);

    /**
     * 批量导入商品评价
     *
     * @param progressKey
     * @param paramList
     * @return Integer
     */
    Integer batchImportItemEval(String progressKey, List<BatchImportItemEvaluateParams> paramList);
}
