package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeXJEnum implements AreaCodeEnumerable {
    CODE_650000("650000", "新疆维吾尔自治区"),
    CODE_650100("650100", "新疆维吾尔族自治区乌鲁木齐市"),
    CODE_650101("650101", "新疆维吾尔族自治区乌鲁木齐市市辖区"),
    CODE_650102("650102", "新疆维吾尔族自治区乌鲁木齐市天山区"),
    CODE_650103("650103", "新疆维吾尔族自治区乌鲁木齐市沙依巴克区"),
    CODE_650104("650104", "新疆维吾尔族自治区乌鲁木齐市新市区"),
    CODE_650105("650105", "新疆维吾尔族自治区乌鲁木齐市水磨沟区"),
    CODE_650106("650106", "新疆维吾尔族自治区乌鲁木齐市头屯河区"),
    CODE_650107("650107", "新疆维吾尔族自治区乌鲁木齐市南山矿区"),
    CODE_650108("650108", "新疆维吾尔族自治区乌鲁木齐市东山区"),
    CODE_650121("650121", "新疆维吾尔族自治区乌鲁木齐市乌鲁木齐县"),
    CODE_650200("650200", "新疆维吾尔族自治区克拉玛依市"),
    CODE_650201("650201", "新疆维吾尔族自治区克拉玛依市市辖区"),
    CODE_650202("650202", "新疆维吾尔族自治区克拉玛依市独山子区"),
    CODE_650203("650203", "新疆维吾尔族自治区克拉玛依市克拉玛依区"),
    CODE_650204("650204", "新疆维吾尔族自治区克拉玛依市白碱滩区"),
    CODE_650205("650205", "新疆维吾尔族自治区克拉玛依市乌尔禾区"),
    CODE_652100("652100", "新疆维吾尔族自治区吐鲁番地区"),
    CODE_652101("652101", "新疆维吾尔族自治区吐鲁番地区吐鲁番市"),
    CODE_652122("652122", "新疆维吾尔族自治区吐鲁番地区鄯善县"),
    CODE_652123("652123", "新疆维吾尔族自治区吐鲁番地区托克逊县"),
    CODE_652200("652200", "新疆维吾尔族自治区哈密地区"),
    CODE_652201("652201", "新疆维吾尔族自治区哈密地区哈密市"),
    CODE_652222("652222", "新疆维吾尔族自治区哈密地区巴里坤哈萨克自治县"),
    CODE_652223("652223", "新疆维吾尔族自治区哈密地区伊吾县"),
    CODE_652300("652300", "新疆维吾尔族自治区昌吉回族自治州"),
    CODE_652301("652301", "新疆维吾尔族自治区昌吉回族自治州昌吉市"),
    CODE_652302("652302", "新疆维吾尔族自治区昌吉回族自治州阜康市"),
    CODE_652303("652303", "新疆维吾尔族自治区昌吉回族自治州米泉市"),
    CODE_652323("652323", "新疆维吾尔族自治区昌吉回族自治州呼图壁县"),
    CODE_652324("652324", "新疆维吾尔族自治区昌吉回族自治州玛纳斯县"),
    CODE_652325("652325", "新疆维吾尔族自治区昌吉回族自治州奇台县"),
    CODE_652327("652327", "新疆维吾尔族自治区昌吉回族自治州吉木萨尔县"),
    CODE_652328("652328", "新疆维吾尔族自治区昌吉回族自治州木垒哈萨克自治县"),
    CODE_652700("652700", "新疆维吾尔族自治区博尔塔拉蒙古自治州"),
    CODE_652701("652701", "新疆维吾尔族自治区博尔塔拉蒙古自治州博乐市"),
    CODE_652722("652722", "新疆维吾尔族自治区博尔塔拉蒙古自治州精河县"),
    CODE_652723("652723", "新疆维吾尔族自治区博尔塔拉蒙古自治州温泉县"),
    CODE_652800("652800", "新疆维吾尔族自治区巴音郭楞蒙古自治州"),
    CODE_652801("652801", "新疆维吾尔族自治区巴音郭楞蒙古自治州库尔勒市"),
    CODE_652822("652822", "新疆维吾尔族自治区巴音郭楞蒙古自治州轮台县"),
    CODE_652823("652823", "新疆维吾尔族自治区巴音郭楞蒙古自治州尉犁县"),
    CODE_652824("652824", "新疆维吾尔族自治区巴音郭楞蒙古自治州若羌县"),
    CODE_652825("652825", "新疆维吾尔族自治区巴音郭楞蒙古自治州且末县"),
    CODE_652826("652826", "新疆维吾尔族自治区巴音郭楞蒙古自治州焉耆回族自治县"),
    CODE_652827("652827", "新疆维吾尔族自治区巴音郭楞蒙古自治州和静县"),
    CODE_652828("652828", "新疆维吾尔族自治区巴音郭楞蒙古自治州和硕县"),
    CODE_652829("652829", "新疆维吾尔族自治区巴音郭楞蒙古自治州博湖县"),
    CODE_652900("652900", "新疆维吾尔族自治区阿克苏地区"),
    CODE_652901("652901", "新疆维吾尔族自治区阿克苏地区阿克苏市"),
    CODE_652922("652922", "新疆维吾尔族自治区阿克苏地区温宿县"),
    CODE_652923("652923", "新疆维吾尔族自治区阿克苏地区库车县"),
    CODE_652924("652924", "新疆维吾尔族自治区阿克苏地区沙雅县"),
    CODE_652925("652925", "新疆维吾尔族自治区阿克苏地区新和县"),
    CODE_652926("652926", "新疆维吾尔族自治区阿克苏地区拜城县"),
    CODE_652927("652927", "新疆维吾尔族自治区阿克苏地区乌什县"),
    CODE_652928("652928", "新疆维吾尔族自治区阿克苏地区阿瓦提县"),
    CODE_652929("652929", "新疆维吾尔族自治区阿克苏地区柯坪县"),
    CODE_653000("653000", "新疆维吾尔族自治区克孜勒苏柯尔克孜自治州"),
    CODE_653001("653001", "新疆维吾尔族自治区克孜勒苏柯尔克孜自治州阿图什市"),
    CODE_653022("653022", "新疆维吾尔族自治区克孜勒苏柯尔克孜自治州阿克陶县"),
    CODE_653023("653023", "新疆维吾尔族自治区克孜勒苏柯尔克孜自治州阿合奇县"),
    CODE_653024("653024", "新疆维吾尔族自治区克孜勒苏柯尔克孜自治州乌恰县"),
    CODE_653100("653100", "新疆维吾尔族自治区喀什地区"),
    CODE_653101("653101", "新疆维吾尔族自治区喀什地区喀什市"),
    CODE_653121("653121", "新疆维吾尔族自治区喀什地区疏附县"),
    CODE_653122("653122", "新疆维吾尔族自治区喀什地区疏勒县"),
    CODE_653123("653123", "新疆维吾尔族自治区喀什地区英吉沙县"),
    CODE_653124("653124", "新疆维吾尔族自治区喀什地区泽普县"),
    CODE_653125("653125", "新疆维吾尔族自治区喀什地区莎车县"),
    CODE_653126("653126", "新疆维吾尔族自治区喀什地区叶城县"),
    CODE_653127("653127", "新疆维吾尔族自治区喀什地区麦盖提县"),
    CODE_653128("653128", "新疆维吾尔族自治区喀什地区岳普湖县"),
    CODE_653129("653129", "新疆维吾尔族自治区喀什地区伽师县"),
    CODE_653130("653130", "新疆维吾尔族自治区喀什地区巴楚县"),
    CODE_653131("653131", "新疆维吾尔族自治区喀什地区塔什库尔干塔吉克自治县"),
    CODE_653200("653200", "新疆维吾尔族自治区和田地区"),
    CODE_653201("653201", "新疆维吾尔族自治区和田地区和田市"),
    CODE_653221("653221", "新疆维吾尔族自治区和田地区和田县"),
    CODE_653222("653222", "新疆维吾尔族自治区和田地区墨玉县"),
    CODE_653223("653223", "新疆维吾尔族自治区和田地区皮山县"),
    CODE_653224("653224", "新疆维吾尔族自治区和田地区洛浦县"),
    CODE_653225("653225", "新疆维吾尔族自治区和田地区策勒县"),
    CODE_653226("653226", "新疆维吾尔族自治区和田地区于田县"),
    CODE_653227("653227", "新疆维吾尔族自治区和田地区民丰县"),
    CODE_654000("654000", "新疆维吾尔族自治区伊犁哈萨克自治州"),
    CODE_654001("654001", "新疆维吾尔族自治区伊犁哈萨克自治州奎屯市"),
    CODE_654100("654100", "新疆维吾尔族自治区伊犁哈萨克自治州伊犁地区"),
    CODE_654101("654101", "新疆维吾尔族自治区伊犁哈萨克自治州伊宁市"),
    CODE_654121("654121", "新疆维吾尔族自治区伊犁哈萨克自治州伊宁县"),
    CODE_654122("654122", "新疆自治区伊犁哈萨克自治州察布查尔锡伯自治县"),
    CODE_654123("654123", "新疆维吾尔族自治区伊犁哈萨克自治州霍城县"),
    CODE_654124("654124", "新疆维吾尔族自治区伊犁哈萨克自治州巩留县"),
    CODE_654125("654125", "新疆维吾尔族自治区伊犁哈萨克自治州新源县"),
    CODE_654126("654126", "新疆维吾尔族自治区伊犁哈萨克自治州昭苏县"),
    CODE_654127("654127", "新疆维吾尔族自治区伊犁哈萨克自治州特克斯县"),
    CODE_654128("654128", "新疆维吾尔族自治区伊犁哈萨克自治州尼勒克县"),
    CODE_654200("654200", "新疆维吾尔族自治区塔城地区"),
    CODE_654201("654201", "新疆维吾尔族自治区塔城地区塔城市"),
    CODE_654202("654202", "新疆维吾尔族自治区塔城地区乌苏市"),
    CODE_654221("654221", "新疆维吾尔族自治区塔城地区额敏县"),
    CODE_654223("654223", "新疆维吾尔族自治区塔城地区沙湾县"),
    CODE_654224("654224", "新疆维吾尔族自治区塔城地区托里县"),
    CODE_654225("654225", "新疆维吾尔族自治区塔城地区裕民县"),
    CODE_654226("654226", "新疆维吾尔族自治区塔城地区和布克赛尔蒙古自治县"),
    CODE_654300("654300", "新疆维吾尔族自治区阿勒泰地区"),
    CODE_654301("654301", "新疆维吾尔族自治区阿勒泰地区阿勒泰市"),
    CODE_654321("654321", "新疆维吾尔族自治区阿勒泰地区布尔津县"),
    CODE_654322("654322", "新疆维吾尔族自治区阿勒泰地区富蕴县"),
    CODE_654323("654323", "新疆维吾尔族自治区阿勒泰地区福海县"),
    CODE_654324("654324", "新疆维吾尔族自治区阿勒泰地区哈巴河县"),
    CODE_654325("654325", "新疆维吾尔族自治区阿勒泰地区青河县"),
    CODE_654326("654326", "新疆维吾尔族自治区阿勒泰地区吉木乃县"),
    CODE_659000("659000", "新疆维吾尔族自治区直辖县级行政单位"),
    CODE_659001("659001", "新疆维吾尔族自治区石河子市")
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeXJEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
