package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeXZEnum implements AreaCodeEnumerable {
    CODE_540000("540000", "西藏自治区"),
    CODE_540100("540100", "西藏自治区拉萨市"),
    CODE_540101("540101", "西藏自治区拉萨市市辖区"),
    CODE_540102("540102", "西藏自治区拉萨市城关区"),
    CODE_540121("540121", "西藏自治区拉萨市林周县"),
    CODE_540122("540122", "西藏自治区拉萨市当雄县"),
    CODE_540123("540123", "西藏自治区拉萨市尼木县"),
    CODE_540124("540124", "西藏自治区拉萨市曲水县"),
    CODE_540125("540125", "西藏自治区拉萨市堆龙德庆县"),
    CODE_540126("540126", "西藏自治区拉萨市达孜县"),
    CODE_540127("540127", "西藏自治区拉萨市墨竹工卡县"),
    CODE_542100("542100", "西藏自治区昌都地区"),
    CODE_542121("542121", "西藏自治区昌都地区昌都县"),
    CODE_542122("542122", "西藏自治区昌都地区江达县"),
    CODE_542123("542123", "西藏自治区昌都地区贡觉县"),
    CODE_542124("542124", "西藏自治区昌都地区类乌齐县"),
    CODE_542125("542125", "西藏自治区昌都地区丁青县"),
    CODE_542126("542126", "西藏自治区昌都地区察雅县"),
    CODE_542127("542127", "西藏自治区昌都地区八宿县"),
    CODE_542128("542128", "西藏自治区昌都地区左贡县"),
    CODE_542129("542129", "西藏自治区昌都地区芒康县"),
    CODE_542132("542132", "西藏自治区昌都地区洛隆县"),
    CODE_542133("542133", "西藏自治区昌都地区边坝县"),
    CODE_542134("542134", "西藏自治区昌都地区盐井县"),
    CODE_542135("542135", "西藏自治区昌都地区碧土县"),
    CODE_542136("542136", "西藏自治区昌都地区妥坝县"),
    CODE_542137("542137", "西藏自治区昌都地区生达县"),
    CODE_542200("542200", "西藏自治区山南地区"),
    CODE_542221("542221", "西藏自治区山南地区乃东县"),
    CODE_542222("542222", "西藏自治区山南地区扎囊县"),
    CODE_542223("542223", "西藏自治区山南地区贡嘎县"),
    CODE_542224("542224", "西藏自治区山南地区桑日县"),
    CODE_542225("542225", "西藏自治区山南地区琼结县"),
    CODE_542226("542226", "西藏自治区山南地区曲松县"),
    CODE_542227("542227", "西藏自治区山南地区措美县"),
    CODE_542228("542228", "西藏自治区山南地区洛扎县"),
    CODE_542229("542229", "西藏自治区山南地区加查县"),
    CODE_542231("542231", "西藏自治区山南地区隆子县"),
    CODE_542232("542232", "西藏自治区山南地区错那县"),
    CODE_542233("542233", "西藏自治区山南地区浪卡子县"),
    CODE_542300("542300", "西藏自治区日喀则地区"),
    CODE_542301("542301", "西藏自治区日喀则地区日喀则市"),
    CODE_542322("542322", "西藏自治区日喀则地区南木林县"),
    CODE_542323("542323", "西藏自治区日喀则地区江孜县"),
    CODE_542324("542324", "西藏自治区日喀则地区定日县"),
    CODE_542325("542325", "西藏自治区日喀则地区萨迦县"),
    CODE_542326("542326", "西藏自治区日喀则地区拉孜县"),
    CODE_542327("542327", "西藏自治区日喀则地区昂仁县"),
    CODE_542328("542328", "西藏自治区日喀则地区谢通门县"),
    CODE_542329("542329", "西藏自治区日喀则地区白朗县"),
    CODE_542330("542330", "西藏自治区日喀则地区仁布县"),
    CODE_542331("542331", "西藏自治区日喀则地区康马县"),
    CODE_542332("542332", "西藏自治区日喀则地区定结县"),
    CODE_542333("542333", "西藏自治区日喀则地区仲巴县"),
    CODE_542334("542334", "西藏自治区日喀则地区亚东县"),
    CODE_542335("542335", "西藏自治区日喀则地区吉隆县"),
    CODE_542336("542336", "西藏自治区日喀则地区聂拉木县"),
    CODE_542337("542337", "西藏自治区日喀则地区萨嘎县"),
    CODE_542338("542338", "西藏自治区日喀则地区岗巴县"),
    CODE_542400("542400", "西藏自治区那曲地区"),
    CODE_542421("542421", "西藏自治区那曲地区那曲县"),
    CODE_542422("542422", "西藏自治区那曲地区嘉黎县"),
    CODE_542423("542423", "西藏自治区那曲地区比如县"),
    CODE_542424("542424", "西藏自治区那曲地区聂荣县"),
    CODE_542425("542425", "西藏自治区那曲地区安多县"),
    CODE_542426("542426", "西藏自治区那曲地区申扎县"),
    CODE_542427("542427", "西藏自治区那曲地区索县"),
    CODE_542428("542428", "西藏自治区那曲地区班戈县"),
    CODE_542429("542429", "西藏自治区那曲地区巴青县"),
    CODE_542430("542430", "西藏自治区那曲地区尼玛县"),
    CODE_542500("542500", "西藏自治区阿里地区"),
    CODE_542521("542521", "西藏自治区阿里地区普兰县"),
    CODE_542522("542522", "西藏自治区阿里地区札达县"),
    CODE_542523("542523", "西藏自治区阿里地区噶尔县"),
    CODE_542524("542524", "西藏自治区阿里地区日土县"),
    CODE_542525("542525", "西藏自治区阿里地区革吉县"),
    CODE_542526("542526", "西藏自治区阿里地区改则县"),
    CODE_542527("542527", "西藏自治区阿里地区措勤县"),
    CODE_542528("542528", "西藏自治区阿里地区隆格尔县"),
    CODE_542600("542600", "西藏自治区林芝地区"),
    CODE_542621("542621", "西藏自治区林芝地区林芝县"),
    CODE_542622("542622", "西藏自治区林芝地区工布江达县"),
    CODE_542623("542623", "西藏自治区林芝地区米林县"),
    CODE_542624("542624", "西藏自治区林芝地区墨脱县"),
    CODE_542625("542625", "西藏自治区林芝地区波密县"),
    CODE_542626("542626", "西藏自治区林芝地区察隅县"),
    CODE_542627("542627", "西藏自治区林芝地区朗县"),
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeXZEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
