package com.qiho.center.api.enums.user;

import lombok.Getter;

import java.util.Arrays;

/**
 * 用户黑名单类型
 *
 * @author peanut.huang
 * @date 2020/6/22
 * @since JDK 1.8
 */
@Getter
public enum UserBlacklistEnum {

    /**
     *
     */
    AUTO_FILL(1, "自动填单黑名单")

    ;

    private Integer type;
    private String desc;

    UserBlacklistEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    /**
     * 根据类型查询
     *
     * @param blackType
     * @return
     */
    public static UserBlacklistEnum findByType(Integer blackType) {
        if(blackType == null){
            return null;
        }

        return Arrays.stream(UserBlacklistEnum.values())
                    .filter(e -> e.getType().equals(blackType))
                    .findFirst()
                    .orElse(null);
    }
}
