package com.qiho.center.api.params;

import lombok.Data;

import java.io.Serializable;

@Data
public class WechatApiPayNotifyParam implements Serializable {
    private static final long serialVersionUID = -2251072814555444761L;

    private String id;

    private String create_time;

    private String resource_type;

    private String event_type;

    //回调摘要
    private String summary;

    private ResourceReq resource;


    @Data
    public static class ResourceReq {
        //加密算法类型
        private String algorithm;

        //数据密文
        private String ciphertext;

        //附加数据
        private String associated_data;

        //原始类型
        private String original_type;

        //随机串
        private String nonce;
    }

    @Data
    public static class Resource {
        //应用ID
        private String appId;

        //商户号
        private String mchid;

        //商户订单号
        private String out_trade_no;

        //微信支付订单号
        private String transaction_id;

        //交易类型
        private String trade_type;

        //交易状态
        private String trade_state;

        //交易状态描述
        private String trade_state_desc;

        //付款银行
        private String bank_type;

        //附加数据
        private String attach;

        //支付完成时间
        private String success_time;

        //支付者信息
        private Payer payer;

        //订单金额信息
        private Amount amount;
    }

    @Data
    public static class Payer {
        private String openid;
    }

    @Data
    public static class Amount {
        //订单总金额，单位为分
        private Integer total;

        //用户支付金额
        private Integer payer_total;

        //货币类型
        private String currency;

        //用户支付币种
        private String payer_currency;
    }
}
