package com.qiho.center.api.remoteservice.blackList;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.bklist.BlackListStrategyDto;

import java.util.List;

/**
 * @author chensong
 * @create 2018-04-25 16:34
 **/
@AdvancedFeignClient
public interface RemoteBlackListStrategrService {

    /**
     * 根据商家id获取黑名单策略
     * @param merchantId -1获取所有的，0获取全部商家，>0查具体的商家
     * @return
     */
    List<BlackListStrategyDto> listByMerchantId(Long merchantId);

    /**
     * 新增黑名单策略
     * @param param
     * @return
     */
    ResultDto<Boolean> createBlackListStrategy(BlackListStrategyDto param);

    /**
     * 删除黑名单策略
     * @param id
     * @Param name 修改人名称
     * @return
     */
    ResultDto<Boolean> deleteBlackListStrategy(Long id, String name);

    /**
     * 更新黑名单策略
     * @param param
     * @return
     */
    ResultDto updateBlackListStrategy(BlackListStrategyDto param);

    /**
     * 根据策略id查询
     * @param id 从
     * @return
     */
    BlackListStrategyDto findById(Long id);


}
