package com.qiho.center.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.user.BaiqiUserAddressDTO;
import com.qiho.center.api.params.user.UserAddressQueryParam;

/**
 * 用户地址相关服务
 *
 * @author peanut.huang
 * @date 2020/6/24
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteUserAddressService {

    /**
     * 根据参数查询用户地址
     * <p>
     *     a、有deviceId的情况下优先根据deviceId查询百奇静态库的用户地址信息
     *     b、静态无数据时根据appId和userId查询sdk的接口获取用户地址信息
     * </p>
     *
     * @param addressQueryParam 查询参数
     * @return
     */
    BaiqiUserAddressDTO selectByParam(UserAddressQueryParam addressQueryParam);
}
