/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.api.util;

import cn.com.duiba.wolf.utils.BlowfishUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenerateLandSecretKeyUtils {
    private static final Logger logger = LoggerFactory.getLogger(GenerateLandSecretKeyUtils.class);
    private static final String SALT = "-";
    private static final String KEY = "abc123";

    public static String generateLandSecretKey(Long pid, Long itemId) {
        if (pid == null || pid == null) {
            throw new IllegalArgumentException("landId or pid can not be null");
        }
        String str = pid + SALT + itemId;
        return BlowfishUtils.encryptBlowfish((String)str, (String)KEY);
    }

    public static Long[] decryptSecretKey(String secret) {
        if (StringUtils.isBlank((CharSequence)secret)) {
            throw new IllegalArgumentException("\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long[] result = new Long[2];
        try {
            String s = BlowfishUtils.decryptBlowfish((String)secret, (String)KEY);
            if (s == null) {
                throw new IllegalArgumentException("\u89e3\u5bc6\u5931\u8d25");
            }
            String[] split = s.split(SALT);
            result[0] = Long.valueOf(split[0]);
            result[1] = Long.valueOf(split[1]);
        }
        catch (Exception ex) {
            logger.warn("\u89e3\u5bc6\u843d\u5730\u9875Id\u5931\u8d25 secret:{}", (Object)secret, (Object)ex);
        }
        return result;
    }

    public static void main(String[] args) {
        String s = GenerateLandSecretKeyUtils.generateLandSecretKey(1231L, 123L);
        System.out.println(s);
        Long[] longs = GenerateLandSecretKeyUtils.decryptSecretKey(s);
        System.out.println(longs[0]);
        System.out.println(longs[1]);
    }
}

