package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 *  Banner类型枚举
 * Created by chensong on 2017/10/26 0026.
 */
public enum BannerTypeEnum {

    /** 轮播图 */
    CAROUSEL("CAROUSEL","轮播图"),

    /** 推荐位 */
    RECOMMEND("RECOMMEND","推荐位");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private BannerTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static BannerTypeEnum getByCode(String code) {
        for (BannerTypeEnum enumVal : BannerTypeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }



}
