package com.qiho.center.api.remoteservice.merchant;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.merchant.ItemMerchantDto;

import java.util.List;
import java.util.Set;

/**
 * 商品-商家 远程服务接口
 *
 * @author chensong
 * @create 2017-11-16 15:03
 **/
@AdvancedFeignClient
public interface RemoteItemMerchantService {

    /**
     * 根据商品id 删除对应你关系
     *
     * @param itemId
     * @return
     */
    Integer deleteByItemId(Long itemId, Long gmtModifier);

    /**
     * 插入商品-商家对应关系
     *
     * @param dto
     * @return
     * @throws BizException
     */
    Integer insert(ItemMerchantDto dto) throws BizException;

    /**
     * 根据商品id列表批量 删除对应关系
     *
     * @param itemIdList
     * @return
     */
    Integer deleteBatchByItemId(List<Long> itemIdList, Long gmtModifier);

    /* 批量删除 商品-商家对应关系
    * @param itemIds 商品id列表
    * @return
    */
    Integer deleteBatch(Set<Long> itemIds, Long gmtModifier) throws BizException;

    /**
     * 根据商品 id 查询所属商家 id
     * @param itemId 商品 id
     * @return 商家 id
     */
    Long selectMerchantIdByItemId(Long itemId);
}
