/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.api.enums.component;

import com.qiho.center.api.enums.component.ComponentBaseTypeEnum;
import com.qiho.center.api.enums.component.ComponentUsageTypeEnum;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ComponentTypeEnum {
    ORDER_FORM(1, "ORDER_FORM", "\u8868\u5355", true, ComponentBaseTypeEnum.ITEM_BASIC, ComponentUsageTypeEnum.ITEM_DEATIL),
    ORDER_BUTTON(2, "ORDER_BUTTON", "\u6309\u94ae", true, ComponentBaseTypeEnum.ITEM_BASIC, ComponentUsageTypeEnum.ITEM_DEATIL),
    ITEM_DETAIL(3, "ITEM_DETAIL", "\u5546\u54c1\u8be6\u60c5", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),
    SLIDE_SHOW(5, "SLIDE_SHOW", "\u8f6e\u64ad\u56fe", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),
    VIDEO(50, "VIDEO", "\u89c6\u9891", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),
    SALE_COMPONENT(51, "SALE_COMPONENT", "\u8425\u9500\u7ec4\u4ef6", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),
    GENERAL_PURPOSE_COMPONENT(52, "GENERAL_PURPOSE_COMPONENT", "\u901a\u7528\u7ec4\u4ef6", false, ComponentBaseTypeEnum.ITEM_BASIC, ComponentUsageTypeEnum.ITEM_DEATIL),
    ITEM_LIST(10, "ITEM_LIST", "\u5546\u54c1\u5217\u8868", false, null, ComponentUsageTypeEnum.COLLECTION_PAGE),
    BANNER(11, "BANNER", "\u8f6e\u64ad\u56fe", false, null, ComponentUsageTypeEnum.COLLECTION_PAGE),
    WAIST_SEAL(12, "WAIST_SEAL", "\u56fe\u7247", false, null, ComponentUsageTypeEnum.COLLECTION_PAGE),
    COLLECTION_BUOY(13, "COLLECTION_BUOY", "\u6d6e\u6807", false, null, ComponentUsageTypeEnum.COLLECTION_PAGE),
    SHOW_ADVERT(14, "SHOW_ADVERT", "\u5c55\u793a\u5e7f\u544a", false, null, ComponentUsageTypeEnum.COLLECTION_PAGE),
    COLLECTION_MARQUEE(15, "COLLECTION_MARQUEE", "\u8dd1\u9a6c\u706f", false, null, ComponentUsageTypeEnum.COLLECTION_PAGE),
    COUNT_DOWN(16, "COUNT_DOWN", "\u5012\u8ba1\u65f6", false, null, ComponentUsageTypeEnum.COLLECTION_PAGE);

    private String code;
    private String desc;
    private Integer num;
    private Boolean required;
    private ComponentBaseTypeEnum baseType;
    private ComponentUsageTypeEnum usageType;

    private ComponentTypeEnum(Integer num, String code, String desc, Boolean required, ComponentBaseTypeEnum baseType, ComponentUsageTypeEnum usageType) {
        this.code = code;
        this.desc = desc;
        this.num = num;
        this.required = required;
        this.baseType = baseType;
        this.usageType = usageType;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getNum() {
        return this.num;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public ComponentBaseTypeEnum getBaseType() {
        return this.baseType;
    }

    public ComponentUsageTypeEnum getUsageType() {
        return this.usageType;
    }

    public static ComponentTypeEnum getByNum(Integer num) {
        if (num == null) {
            return null;
        }
        return ((Stream)Stream.of(ComponentTypeEnum.values()).parallel()).filter(e -> e.getNum().equals(num)).findFirst().orElse(null);
    }

    public static List<ComponentTypeEnum> fetchNecessaryComponent(ComponentUsageTypeEnum usageType) {
        List<ComponentTypeEnum> list = Stream.of(ComponentTypeEnum.values()).filter(e -> e.getUsageType().equals((Object)usageType) && e.getRequired() != false).collect(Collectors.toList());
        return list;
    }

    public static List<ComponentTypeEnum> getByUsageType(ComponentUsageTypeEnum usageType) {
        List<ComponentTypeEnum> list = Stream.of(ComponentTypeEnum.values()).filter(e -> e.getUsageType().equals((Object)usageType)).collect(Collectors.toList());
        return list;
    }
}

