package com.qiho.center.api.dto;

import java.util.Date;

/** 商家验证信息实体
 * @author jiafeng.geng
 * @create 2018-03-06 11:42:21
 **/
public class OpenInterfaceDto extends BaseDto{


    /** 主键Id */
    private Long id;

    /**
     * 类型 {@link com.qiho.center.api.enums.OpenInterfaceTypeEnum}
     */
    private Integer interfaceType;

    /**
     * 商家id
     */
    private Long merchantId;

    /**
     * 商家名称
     */
    private String merchantName;

    /**
     * appkey
     */
    private String appkey;

    /**
     * appsecret
     */
    private String appsecret;


    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 0代表是该key没有从商家后台生成过,1代表从商家后台生成过
     *  {@link com.qiho.center.api.enums.OpenInterfaceMerchantSourceActivateEnum}
     * @author fanjia
     * @date 2022/3/31 下午1:52
     * @param null
     * @return null
     */
    private Integer merchantSourceActivate;

    public Integer getMerchantSourceActivate() {
        return merchantSourceActivate;
    }

    public void setMerchantSourceActivate(Integer merchantSourceActivate) {
        this.merchantSourceActivate = merchantSourceActivate;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantName() { return merchantName; }

    public void setMerchantName(String merchantName) { this.merchantName = merchantName; }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey == null ? null : appkey.trim();
    }

    public String getAppsecret() {
        return appsecret;
    }

    public void setAppsecret(String appsecret) {
        this.appsecret = appsecret == null ? null : appsecret.trim();
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getInterfaceType() {
        return interfaceType;
    }

    public void setInterfaceType(Integer interfaceType) {
        this.interfaceType = interfaceType;
    }
}
