package com.qiho.center.api.dto.ordertmpauto;

import com.qiho.center.api.dto.discount.OrderDiscountDto;
import com.qiho.center.api.dto.ordertmp.OrderTmpDto;
import lombok.Data;

import java.util.List;

@Data
public class OrderTmpAutoDetailDTO extends OrderTmpDto {

    /**
     * 商品简称
     */
    private String  itemShortName;

    /**
     * 图片
     */
    private String  image;

    /**
     * sku名称
     */
    private String  skuName;

    /**
     * 下单URL
     */
    private String  url;

    /**
     * 下单URL拓展
     */
    private String urlExt;

    /**
     * ip地址
     */
    private String  ip;

    /**
     * 用户代理，包含用户操作系统及浏览器版本等信息
     */
    private String  userAgent;

    /**
     * 售价，单位：分
     */
    private Integer sellingPrice;

    /**
     * 订单原始金额
     */
    private Integer originalPrice;

    /**
     * 商品件数
     */
    private Integer quantity;

    /**
     * 支付方式
     */
    private String  payType;

    /**
     * 订单金额
     */
    private Integer orderAmt;

    /**
     * 省
     */
    private String  province;

    /**
     * 市
     */
    private String  city;

    /**
     * 区
     */
    private String  district;

    /**
     * 详细地址
     */
    private String  address;

    /**
     * 用户留言
     */
    private String  message;

    /**
     * tuiaId
     */
    private String  tuiaId;

    /**
     * 页面停留时间
     */
    private Long remainTime;

    /**
     * 商品成本
     */
    private Integer itemCost;

    /**
     * 订单原始金额
     */
    private Integer orderOriginalAmt;

    /**
     * 快递派送时间
     */
    private String sendTime;

    /**
     * ssjx来源参数
     */
    private String sid;

    /**
     * 前端传的tokenId
     */
    private String tokenId;

    /**
     * 皮肤id
     */
    private Long skinId;

    /**
     * appId
     */
    private Long appId;

    /**
     * A/B test实验code
     */
    private String planCode;

    /**
     * 推啊用户id
     */
    private String tuiaCid;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * 命中的防作弊信息
     */
    private List<String> anticheatRules;

    /**
     * 商家名称
     */
    private String merchantName;

    /**
     * 下单用户Id
     */
    private Long userId;

    /**
     * 用户身份证号
     */
    private String idCard;

    /**
     * 下单的页面ID
     */
    private Long pageId;

    /**
     * 下单的页面表单顺序
     */
    private Integer formNumber;

    /**
     * 订单扩展字段
     */
    private String extJson;

    /**
     * 是否是拼团
     */
    private Integer isGroupbuy;

    /**
     * 验证码 因为后续会存在三思德等规则的对接 这个过程中需要结合验证码对规则进行校验 所以将用户提交的短信验证码 进行临时订单落库
     */
    private String  smsCode;

    /**
     * 设备类型
     */
    private String deviceType;

    /**
     * 优惠信息
     */
    private OrderDiscountDto orderDiscountDto;

    /**
     * 新tuiaId
     */
    private String newTuiaId;
}
