package com.qiho.center.api.enums;

import java.util.HashSet;
import java.util.Set;

/**
 * @author Wangpf
 * @description
 * @date 2021/2/25 11:35 上午
 */
public enum AreaCodeEnum {

    BEIJING("11", "北京"),
    TIANJIN("12", "天津"),
    HEBEI("13", "河北"),
    SHANXI("14", "山西"),
    NEIMENGGU("15", "内蒙古"),
    LIAONING("21", "辽宁"),
    JILIN("22", "吉林"),
    HEILONGJIANG("23", "黑龙江"),
    SHANGHAI("31", "上海"),
    JIANGSU("32", "江苏"),
    ZHEJIANG("33", "浙江"),
    ANHUI("34", "安徽"),
    FUJIAN("35", "福建"),
    JIANGXI("36", "江西"),
    SHANDONG("37", "山东"),
    HENAN("41", "河南"),
    HUBEI("42", "湖北"),
    HUNAN("43", "湖南"),
    GUANGDONG("44", "广东"),
    GUANGXI("45", "广西"),
    HAINAN("46", "海南"),
    CHONGQING("50", "重庆"),
    SICHUAN("51", "四川"),
    GUIZHOU("52", "贵州"),
    YUNNAN("53", "云南"),
    XIZANG("54", "西藏"),
    SHANXI_("61", "陕西"),
    GANSU("62", "甘肃"),
    QINGHAI("63", "青海"),
    NINGXIA("64", "宁夏"),
    XINJIANG("65", "新疆"),
    TAIWAN("71", "台湾"),
    XIANGGANG("81", "香港"),
    AOMEN("82", "澳门"),
    GUIWAI("91", "国外"),

    ;

    /**
     * 城市编码
     */
    private final String code;

    /**
     * 城市
     */
    private final String province;

    AreaCodeEnum(String code, String province) {
        this.code = code;
        this.province = province;
    }

    public String getCode() {
        return code;
    }

    public String getProvince() {
        return province;
    }

    public static final Set<String> CODES = new HashSet<>(24);

    static {
        for (AreaCodeEnum value : AreaCodeEnum.values()) {
            CODES.add(value.getCode());
        }
    }

}
