/**
 * Project Name:qiho-center-api File Name:OrderStatusEnum.java Package Name:com.qiho.center.api.enums
 * Date:2017年6月2日下午1:52:08 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.enums;


import org.apache.commons.lang.StringUtils;

/**
 * ClassName:OrderStatusEnum <br/>
 * 订单状态枚举. <br/>
 * Date: 2017年6月2日 下午1:52:08 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public enum OrderStatusEnum {
    /** 待付款 */
    TO_PAY("TO_PAY", "待付款"),
    
    /** 订单待审核 */
    TO_APPROVE("TO_APPROVE", "待确认"),

    /** 订单待发货 */
    TO_SEND("TO_SEND", "待发货"),

    /** 订单已发货 */
    SEND_OUT("SEND_OUT", "已发货"),

    /** 订单已取消 */
    CANCELLED("CANCELLED", "已取消"),

    /** 订单交易成功 */
    SUCCESS("SUCCESS", "交易成功"),

    /** 订单交易关闭 */
    CLOSED("CLOSED", "交易关闭"),

    /** 订单软删 */
    SOFT_DELETE("SOFT_DELETE", "已删除");

    /** 代码 */
    private final String code;

    /** 描述 */
    private final String desc;

    OrderStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * @param code
     * @return DatabaseSchema
     */
    public static OrderStatusEnum getByCode(String code) {
        for (OrderStatusEnum enumVal : OrderStatusEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(String code) {
        for (OrderStatusEnum enumVal : OrderStatusEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal.getDesc();
            }
        }
        return null;
    }

    /**
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}
