package com.qiho.center.api.enums.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author huangruodan
 * @version 创建时间：2021/4/19 下午5:11
 */
@Getter
@AllArgsConstructor
public enum CheatParamNameEnum {

    NAME("name", "姓名"),
    ID_CARD("idCard", "身份证号"),
    MOBILE("mobile", "手机号"),
    PROVINCE("province", "省份"),
    CITY("city", "城市"),
    AREA("area", "区"),
    ADDRESS("address", "地址"),
    CHANNEL_ID("channelId", "渠道信息");

    private static Map<String, CheatParamNameEnum> paramMap = new HashMap<>();
    static {
        paramMap.put(NAME.getType(), NAME);
        paramMap.put(ID_CARD.getType(), ID_CARD);
        paramMap.put(MOBILE.getType(), MOBILE);
        paramMap.put(PROVINCE.getType(), PROVINCE);
        paramMap.put(CITY.getType(), CITY);
        paramMap.put(AREA.getType(), AREA);
        paramMap.put(ADDRESS.getType(), ADDRESS);
        paramMap.put(CHANNEL_ID.getType(), CHANNEL_ID);
    }

    private String type;

    private String desc;

    public static CheatParamNameEnum getByType(String type) {
        return paramMap.get(type);
    }

}
