package com.qiho.center.api.enums.trading.withdrawal;

import cn.com.duiba.boot.exception.BizException;

import java.util.stream.Stream;

/**
 * @author Wangpf
 * @description 提现状态
 * @date 2020/9/1 5:07 下午
 */
public enum WithdrawalApplyStatus {

    APPLY_ING(0, "提现中"),

    APPLY_PASS(1, "提现通过"),

    APPLY_REFUSED(2, "提现拒绝");

    private final int code;

    private final String desc;

    WithdrawalApplyStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 检查状态
     *
     * @param status
     */
    public static void checkStatus(int status) throws BizException {
        Stream.of(WithdrawalApplyStatus.values())
            .filter(withdrawalApplyStatus -> status == withdrawalApplyStatus.getCode()).findAny()
            .orElseThrow(() -> new BizException("非法状态"));
    }

    public static String getDescByCode(Integer code) {
        for (WithdrawalApplyStatus withdrawalApplyStatus : WithdrawalApplyStatus.values()) {
            if (code != null && code == withdrawalApplyStatus.getCode()) {
                return withdrawalApplyStatus.getDesc();

            }
        }
        return null;
    }
}
