package com.qiho.center.api.params.needsync.cancelledorder;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;

/**
 * 查询条件 Params
 * @dateTime 2020-08-05 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class GainConditionParams implements Serializable {


    /**
     * 反馈日期·{ 区间 }·开始时间
     * -- { 时间戳 :: ms : 毫秒 }
     */
    private long startTime;

    /**
     * 反馈日期·{ 区间 }·截止时间
     * -- { 时间戳 :: ms : 毫秒 }
     */
    private long endTime;

    /**
     * 商家·Id
     */
    private Long merchantId;

    /**
     * 状态
     * -- { 0 : 未导出 , 1 : 已导出 }.
     */
    private Integer status;

    /**
     * 订单·手机号
     */
    private String mobile;

}
