package com.qiho.center.api.params.needsync.cancelledorder;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Optional;

/**
 * 分页条件 Params
 * @dateTime 2020-08-05 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@Accessors(fluent = false, chain = true, prefix = "")
public class GainPagingParams extends GainConditionParams implements Serializable {


    /**
     * 页码
     */
    @JSONField(alternateNames = { "currentPage", "pageNum" })
    private Integer page;

    /**
     * 条数
     */
    @JSONField(alternateNames = { "pageSize" })
    private Integer size;

    /**
     * 下标
     * -- 开始下标
     */
    private Integer subscript;


    /**
     * 验证赋值
     */
    public GainPagingParams validate() {
        int page = Optional.ofNullable(this.getPage()).orElse(1);
        int size = Optional.ofNullable(this.getSize()).orElse(50);
        this.setSubscript((page - 1) * size).setSize(size).setPage(page);
        return this;
    }

}
