package com.qiho.center.api.remoteservice.campaign;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.campaign.ChannelDto;
import com.qiho.center.api.params.ChannelParams;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by danke on 2017/6/16.
 * 渠道暴露服务接口
 */
@AdvancedFeignClient
public interface RemoteChannelService {

    /**
     * 分页查询
     */
    DubboResult<PagenationDto<ChannelDto>> queryChannelByPage(ChannelParams params, Integer pageNum, Integer pageSize);

    /**
     * 通过id删除
     */
    DubboResult<Boolean> deleteChannelById(Long id, String updator);

    /**
     * 更新
     */
    DubboResult<Boolean> updateChannelByParam(ChannelDto channelDto);

    /**
     * 插入
     */
    DubboResult<Integer> insertChannel(ChannelDto channelDto);

    /**
     * 条件查询总记录数
     */
    DubboResult<Integer> countByParam(ChannelParams params);
}
