package com.qiho.center.api.remoteservice.order;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.order.OrderWinDTO;
import com.qiho.center.api.params.ordertmp.OrderWinPageParam;

import java.util.List;

/**
 * @author Wangpf
 * @date 2023/12/5 16:24
 */
@AdvancedFeignClient
public interface RemoteOrderWinService {

    /**
     * 保存中奖记录
     *
     * @param orderWinDTO
     * @return
     */
    boolean save(OrderWinDTO orderWinDTO) throws BizException;

    /**
     * 更新中奖记录
     *
     * @param orderWinDTO
     * @return
     */
    boolean update(OrderWinDTO orderWinDTO);

    /**
     * 分页查询中奖记录
     *
     * @param orderWinPageParam
     * @return
     */
    PagenationDto<OrderWinDTO> page(OrderWinPageParam orderWinPageParam);

    List<OrderWinDTO> queryByCondition(OrderWinPageParam orderWinPageParam);

    /**
     * 根据订单ID查询中奖状态
     *
     * @param orderIds
     * @return
     */
    List<OrderWinDTO> selectByOrderIds(List<String> orderIds);
}
