package com.qiho.center.api.remoteservice.purchase;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.purchase.PurchaseDTO;
import com.qiho.center.api.enums.purchase.PurchaseTypeEnum;

/**
 * 加购服务
 *
 * @author peanut.huang
 * @date 2020/7/10
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemotePurchaseService {

    /**
     * 根据加购类型查询
     *
     * @param purchaseType 加购类型 {@link PurchaseTypeEnum}
     * @return
     */
    PurchaseDTO findByType(String purchaseType);

    /**
     * 保存加购配置
     *
     * @param purchaseDTO
     * @throws BizException
     * @return
     */
    boolean savePurchase(PurchaseDTO purchaseDTO) throws BizException;
}
