package com.qiho.center.api.util;

import com.qiho.center.api.enums.AreaCodeEnum;
import org.apache.commons.lang.StringUtils;

import java.util.regex.Pattern;

/**
 * @author Wangpf
 * @description 身份证号格式校验工具类
 * @date 2021/2/25 11:31 上午
 */
public abstract class IdCardUtil {

    private static String ILLEGAL_CHARACTER = "|{|}|#|$|'|\"|:|;|&|*|@|@|%|^|?";

    private static final char[] ILLEGAL_CHARACTER_ARR = new char[]{'{', '}', '#', '$', '{', '\'', '\"', ':', ';', '&', '*', '@', '@', '%', '^', '?'};

    /**
     * 校验身份证号格式
     *
     * @param idCard
     * @return true -> 满足条件 false -> 不满足条件
     */
    public static boolean checkIdCardFormat(String idCard) {

        //只校验18位身份证
        if (idCard == null || idCard.length() != 18) {
            return false;
        }

        //校验非法字符
        boolean containsAny = StringUtils.containsAny(idCard, ILLEGAL_CHARACTER_ARR);
        if (containsAny) {
            return false;
        }

        //校验身份证区号
        boolean contains = AreaCodeEnum.CODES.contains(idCard.substring(0, 2));
        if(!contains){
            return false;
        }

        //校验身份证号码
        return checkIdCard(idCard);
    }

    /**
     * 该方法由广告主提供的js方法中 翻译过来 需求文档：http://cf.dui88.com/pages/viewpage.action?pageId=96830659
     *
     * @param idCard
     * @return
     */
    private static boolean checkIdCard(String idCard) {

        String ereg;

        String[] idCardArray = idCard.split("");

        boolean flag;

        //身份号码位数及格式检验

        //18位身份号码检测
        //出生日期的合法性检查
        //闰年月日:((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9]))
        //平年月日:((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|1[0-9]|2[0-8]))
        if (Integer.parseInt(idCard.substring(6, 10)) % 4 == 0 || (Integer.parseInt(idCard.substring(6, 10)) % 100 == 0 && Integer.parseInt(idCard.substring(6, 10)) % 4 == 0)) {
            ereg = "^[1-9][0-9]{5}(19|20)[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9]))[0-9]{3}[0-9Xx]$"; //闰年出生日期的合法性正则表达式
        } else {
            ereg = "^[1-9][0-9]{5}(19|20)[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|1[0-9]|2[0-8]))[0-9]{3}[0-9Xx]$"; //平年出生日期的合法性正则表达式
        }
        if (Pattern.matches(ereg, idCard)) {//测试出生日期的合法性
            //计算校验位
            int s = (Integer.parseInt(idCardArray[0]) + Integer.parseInt(idCardArray[10])) * 7
                + (Integer.parseInt(idCardArray[1]) + Integer.parseInt(idCardArray[11])) * 9
                + (Integer.parseInt(idCardArray[2]) + Integer.parseInt(idCardArray[12])) * 10
                + (Integer.parseInt(idCardArray[3]) + Integer.parseInt(idCardArray[13])) * 5
                + (Integer.parseInt(idCardArray[4]) + Integer.parseInt(idCardArray[14])) * 8
                + (Integer.parseInt(idCardArray[5]) + Integer.parseInt(idCardArray[15])) * 4
                + (Integer.parseInt(idCardArray[6]) + Integer.parseInt(idCardArray[16])) * 2
                + Integer.parseInt(idCardArray[7]) * 1
                + Integer.parseInt(idCardArray[8]) * 6
                + Integer.parseInt(idCardArray[9]) * 3;
            int y = s % 11;
            String m = "F";
            String jym = "10X98765432";
            m = jym.substring(y, y + 1); //判断校验位
            flag = m.equals(idCardArray[17]); //检测ID的校验位
        } else {
            flag = false;
        }

        return flag;
    }

    public static void main(String[] args) {
        String idCard = "610632197407172015";
        System.out.println(checkIdCardFormat(idCard));
    }
}
