package com.qiho.center.api.dto.trading.record;

import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.enums.trading.statistics.CloseStatusEnum;
import io.swagger.models.auth.In;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author Wangpf
 * @description
 * @date 2020/9/2 10:24 上午
 */
@Data
public class ShopTradingRecordDto implements Serializable {

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 店铺Id
     */
    private Long shopId;

    /**
     * 订单Id
     */
    private String orderId;

    /**
     * 商品Id
     */
    private Long itemId;

    /**
     * 支付类型 {@link PayTypeEnum}
     */
    private String payType;

    /**
     * 订单金额
     */
    private Integer orderAmt;

    /**
     * 订单状态
     */
    private String orderStatus;

    /**
     * 订单退款金额
     */
    private Integer orderFundAmt;

    /**
     * 手续费，单位：分
     */
    private Integer poundageAmt;

    /**
     * 手续费率
     */
    private String poundageRate;

    /**
     * 结算状态，{@link CloseStatusEnum#getCode()}
     */
    private String closeStatus;

    /**
     * 订单结算时间
     */
    private String closeTime;

    /**
     * 订单结算金额
     */
    private Integer closeAmt;

    /**
     * 订单的创建时间
     */
    private String orderCreateTime;

    /**
     * 创建时间
     */
    private String gmtCreate;

    /**
     * 修改时间
     */
    private String gmtModified;

    /**
     * 外部流水号
     */
    private String externalSerialNumber;

    /**
     * 店铺名称
     */
    private String shopName;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 订单未关闭的原因 {@link com.qiho.center.api.enums.trading.record.NotCloseReasonEnum}
     */
    private String notCloseReason;

    /**
     * 订单变更为终态的时间
     */
    private String orderTerminalTime;
}
