package com.qiho.center.api.enums;

/**
 * Created by Administrator on 2017/6/16.
 * 用于渠道及媒体计划相关状态枚举
 */
public enum ChannelStatusEnum {

    DELETE(0, "status_delete", "已删除"),

    ONLINE(1, "status_online", "可用状态"),

    HANDUP(2, "status_handup", "挂起");//表示暂时不可用,但是未删除


    int code;
    String value;
    String message;

    public String getValue() {
        return value;
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }


    /**
     * @param code
     * @return
     */
    public static ChannelStatusEnum fromCode(Integer code) {
        if (code==null) {
            return null;
        }
        for (ChannelStatusEnum recordEntrySyncEnvEnum : ChannelStatusEnum.values()) {
            if (recordEntrySyncEnvEnum.getCode() == code) {
                return recordEntrySyncEnvEnum;
            }
        }
        return null;
    }


    ChannelStatusEnum(int code, String value, String message) {
        this.code = code;
        this.value = value;
        this.message = message;
    }
}
