package com.qiho.center.api.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * status 号码状态:
 * 1-正常
 * 2-空号
 * 3-通话中
 * 4-不在网（空号）
 * 5-关机
 * 7-疑似关机
 * 9-服务器异常
 * 13-停机
 * 12-号码错误
 * 10-未知
 *
 * @author Wangpf
 * @date 2024/1/25 11:40
 */
public enum ChuangLanPhoneStatusEnum {
    /**
     * 空号
     */
    EMPTY("2"),

    /**
     * 不在网（空号）
     */
    CLOSING_DOWN("4"),

    /**
     * 号码错误
     */
    BLACK("12");


    private final String code;

    ChuangLanPhoneStatusEnum(String code) {
        this.code = code;

    }

    public String getCode() {
        return code;
    }

    /**
     * 三个状态都是空号
     *
     * @param status
     * @return
     */
    public static boolean isEmpty(String status) {
        return Arrays.stream(ChuangLanPhoneStatusEnum.values()).anyMatch(chuangLanPhoneStatusEnum -> Objects.equals(chuangLanPhoneStatusEnum.getCode(), status));
    }

}
