package com.qiho.center.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 订单类型
 *
 * @author lijicong
 * @since 2020-10-28
 */
@Getter
@AllArgsConstructor
public enum OrderTypeEnum {

    BAIQI("BAIQI", "百奇订单类型"),
    VIRTUAL("VIRTUAL", "虚拟商品类型");

    private final String code;
    private final String desc;

    private static Map<String, OrderTypeEnum> map = Arrays.stream(OrderTypeEnum.values()).collect(Collectors.toMap(OrderTypeEnum::getCode, v -> v));

    public static OrderTypeEnum of(String code) {
        return map.get(code);
    }

}
