package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeSHEnum implements AreaCodeEnumerable {
    CODE_310000("310000", "上海市"),
    CODE_310100("310100", "上海市市辖区"),
    CODE_310101("310101", "上海市黄浦区"),
    CODE_310102("310102", "上海市南市区"),
    CODE_310103("310103", "上海市卢湾区"),
    CODE_310104("310104", "上海市徐汇区"),
    CODE_310105("310105", "上海市长宁区"),
    CODE_310106("310106", "上海市静安区"),
    CODE_310107("310107", "上海市普陀区"),
    CODE_310108("310108", "上海市闸北区"),
    CODE_310109("310109", "上海市虹口区"),
    CODE_310110("310110", "上海市杨浦区"),
    CODE_310112("310112", "上海市闵行区"),
    CODE_310113("310113", "上海市宝山区"),
    CODE_310114("310114", "上海市嘉定区"),
    CODE_310115("310115", "上海市浦东新区"),
    CODE_310116("310116", "上海市金山区"),
    CODE_310117("310117", "上海市松江区"),
    CODE_310200("310200", "上海市县"),
    CODE_310225("310225", "上海市南汇县"),
    CODE_310226("310226", "上海市奉贤县"),
    CODE_310229("310229", "上海市青浦县"),
    CODE_310230("310230", "上海市崇明县"),;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeSHEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
