package com.qiho.center.api.params.ordertmpauto;

import com.qiho.center.api.params.PageQueryParams;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class OrderTmpAutoPageParam extends PageQueryParams {

    /**
     * 订单id
     */
    private String orderId;

    /**
     * 商品id
     */
    private Long itemId;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 商家id
     */
    private Long merchantId;

    /**
     * 创建时间-开始
     */
    private Date startTimeOfCreate;

    /**
     * 创建时间-结束
     */
    private Date endTimeOfCreate;

    /**
     * 更新时间-开始
     */
    private Date startTimeOfModified;

    /**
     * 更新时间-结束
     */
    private Date endTimeOfModified;

    /**
     * 订单类型 0-不完整 1-完整
     */
    private Integer orderType;

    /**
     * 当前参数查询关联的AeID
     */
    private Long relevantAeId;

    private Integer orderStatus;

    /**
     * 核单分层
     */
    private List<Integer> deliveryIndustryDcvrLevelList;
}
