package com.qiho.center.api.params.param;

import java.io.Serializable;
import java.util.List;

/**
 * @author Wangpf
 * @description  page分页查询参数
 * @date 2020/3/13 11:37 AM
 */
public class PagePagingParam implements Serializable {

    /**
     * 页面名称
     */
    private String pageName;

    /**
     * 页面类型
     */
    private List<Integer> pageTypes;

    /**
     * 创建者的姓名
     */
    private String createName;

    /**
     * 查询位置开始位置
     */
    private Integer offset;

    /**
     * 单页展示条数
     */
    private Integer pageSize;

    /**
     * 页面类型和 {@link PagePagingParam#getPageTypes() 区分} 只是用来区分我的落地页和其他
     */
    private Integer originType;

    /**
     * 商家 id 集合
     */
    private List<Long> merchantIds;

    public List<Long> getMerchantIds() {
        return merchantIds;
    }

    public void setMerchantIds(List<Long> merchantIds) {
        this.merchantIds = merchantIds;
    }

    public String getPageName() {
        return pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public List<Integer> getPageTypes() {
        return pageTypes;
    }

    public void setPageTypes(List<Integer> pageTypes) {
        this.pageTypes = pageTypes;
    }

    public Integer getOffset() {
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public Integer getOriginType() {
        return originType;
    }

    public void setOriginType(Integer originType) {
        this.originType = originType;
    }
}
