package com.qiho.center.api.remoteservice.blackList;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.bklist.BaiqiBlackListDto;
import com.qiho.center.api.params.blacklist.BaiqiBlackListQueryParam;
import com.qiho.center.api.params.blacklist.BlackListBatchDealParam;

import java.util.List;

/** 新的黑名单远程接口
 * @author chensong
 * @create 2018-04-27 15:16
 **/
@AdvancedFeignClient
public interface RemoteBaiqiBlackListService {

    /**
     * 黑名单分页查询
     * @param param
     * @return
     */
    PagenationDto<BaiqiBlackListDto> queryBlackListPage(BaiqiBlackListQueryParam param);

    /**
     * 删除黑名单策略
     * @param name
     * @param id
     * @return
     */
    ResultDto<Boolean> deleteBlackList(String name, Long id);

    /**
     * 分页查询统计
     * @param param
     * @return
     */
    int queryBlackListPageCount(BaiqiBlackListQueryParam param);

    /**
     * 批量添加黑名单
     * @param cacheKey 任务id
     * @param list  黑名单数据
     * @param merchantId 商家id
     * @return
     */
    int batchAddBlackList(String cacheKey, List<BlackListBatchDealParam> list, Long merchantId , String operator);

    /**
     * 通过接口批量新增黑名单
     *
     * @param baiqiBlackListDtos
     * @param merchantId
     * @return
     */
    boolean addBlackList(List<BaiqiBlackListDto> baiqiBlackListDtos, Long merchantId);
}
