package com.qiho.center.api.remoteservice.user;

import com.qiho.center.api.dto.user.WechatUserDto;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 微信用户前台服务
 *
 * @author peanut.huang
 * @date 2018/1/26.
 */
@AdvancedFeignClient
public interface RemoteWechatUserService {

    /**
     * 添加微信用户
     *
     * @param wechatUserDto 微信用户dto
     * @return
     */
    Boolean insertUser(WechatUserDto wechatUserDto);

    /**
     * 根据小程序openId获取百奇用户id
     *
     * @param miniOpenId 小程序openId
     * @return           百奇用户id
     */
    Long findUserIdByMiniOpenId(String miniOpenId);

    /**
     * 根据小程序unionId获取百奇用户id
     *
     * @param unionId 小程序unionId
     * @return           百奇用户id
     */
    WechatUserDto findUserIdByMiniUnionId(String unionId);
}
