package com.qiho.center.api.util;

import static java.math.BigDecimal.ROUND_UNNECESSARY;

import java.math.BigDecimal;

import org.apache.commons.lang.StringUtils;

/**
 * @author chensong
 * @create 2017-07-24 10:38
 **/
public class AliPayAppUtil {

    private AliPayAppUtil(){

    }

    /**
     * 将金额从分转成元单位
     * @param amount
     * @return
     */
    public static String fenToYuan(Integer amount){
        if(amount == null){
            return "0.00";
        }
        return new BigDecimal(amount).divide(new BigDecimal(100),2,ROUND_UNNECESSARY).toString();
    }

    /**
     * 将金额从元转成分单位
     * @param amount
     * @return
     */
    public static Integer yuanToFen(String amount){
        if(StringUtils.isBlank(amount)){
            return 0;
        }
        return new BigDecimal(amount).multiply(new BigDecimal(100)).intValue();
    }

}
