/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.api.enums;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;

public enum PayTypeEnum {
    COD("COD", "\u5706\u901aCOD"),
    ALIPAY("ALIPAY", "\u652f\u4ed8\u5b9d"),
    NOWPAY("NOWPAY", "\u73b0\u5728\u652f\u4ed8"),
    WECHATPAY("WECHATPAY", "\u5fae\u4fe1\u652f\u4ed8"),
    WXPAY_SV("WXPAY_SV", "\u5fae\u4fe1H5\u652f\u4ed8-\u670d\u52a1\u5546\u6a21\u5f0f"),
    WXPAY_APPLET_SV("WXPAY_APPLET_SV", "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u652f\u4ed8-\u670d\u52a1\u5546\u6a21\u5f0f"),
    WECHATPAY_PUB("WECHATPAY_PUB", "\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8"),
    ONLINE("ONLINE", "\u5728\u7ebf\u652f\u4ed8");

    private String code;
    private String desc;
    private static Map<String, PayTypeEnum> enumMap;

    public static PayTypeEnum getEnumByCode(String code) {
        return enumMap.get(code);
    }

    public static String getDescByCode(String code) {
        return Optional.ofNullable(enumMap.get(code)).map(PayTypeEnum::getDesc).orElse(null);
    }

    public static boolean isOnlinePay(String code) {
        return ALIPAY.getCode().equals(code) || WECHATPAY.getCode().equals(code) || WECHATPAY_PUB.getCode().equals(code) || WXPAY_SV.getCode().equals(code) || WXPAY_APPLET_SV.getCode().equals(code);
    }

    private PayTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        enumMap = Maps.newHashMap();
        for (PayTypeEnum it : PayTypeEnum.values()) {
            enumMap.put(it.code, it);
        }
    }
}

