package com.qiho.center.api.dto.page;

import com.qiho.center.api.dto.BaseDto;
import com.qiho.center.api.enums.page.PageStatusEnum;
import com.qiho.center.api.enums.page.PageTypeEnum;

import java.util.Date;

/**
 * @author peanut.huang
 * @date 2018/2/23.
 */
public class BaiqiPageDto extends BaseDto {

    private static final long serialVersionUID = 3531839515998545089L;

    /**
     * 页面id
     */
    private Long id;

    /**
     * 页面名称
     */
    private String pageName;

    /**
     * 页面类型 {@link PageTypeEnum#value}
     */
    private Integer pageType;

    /**
     * 页面地址
     */
    private String pageUrl;

    /**
     * 页面效果图地址
     */
    private String pageImg;

    /**
     * 页面状态 {@link PageStatusEnum#value}
     */
    private Integer pageStatus;

    /**
     * 页面md5
     */
    private String pageMd5;

    /**
     * 页面其他信息
     */
    private String pageInfo;

    /**
     * 页面最后操作人
     */
    private String operatorName;

    /** 创建时间 */
    private Date gmtCreate;

    /** 修改时间 */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPageName() {
        return pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public Integer getPageType() {
        return pageType;
    }

    public void setPageType(Integer pageType) {
        this.pageType = pageType;
    }

    public String getPageUrl() {
        return pageUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public Integer getPageStatus() {
        return pageStatus;
    }

    public void setPageStatus(Integer pageStatus) {
        this.pageStatus = pageStatus;
    }

    public String getPageMd5() {
        return pageMd5;
    }

    public void setPageMd5(String pageMd5) {
        this.pageMd5 = pageMd5;
    }

    public String getPageInfo() {
        return pageInfo;
    }

    public void setPageInfo(String pageInfo) {
        this.pageInfo = pageInfo;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getPageImg() {
        return pageImg;
    }

    public void setPageImg(String pageImg) {
        this.pageImg = pageImg;
    }
}
