/**
 * Project Name:qiho-center-api
 * File Name:RemoteTemplateService.java
 * Package Name:com.qiho.center.api.remoteservice
 * Date:2017年6月21日上午9:30:02
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.TemplateDto;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteTemplateService <br/>
 * 模板dubb服务. <br/>
 * Date:     2017年6月21日 上午9:30:02 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteTemplateService {

    /**
     * 模板开关
     * @author zhanglihui
     * @param id     模板ID
     * @param enable 是否开启
     * @return DubboResult
     */
    DubboResult<Void> enableSwitch(Long id, Boolean enable);
    
    /**
     * 新增模板
     *
     * @author zhanglihui
     * @param templateCode    模板代码
     * @param templateName    模板名称
     * @param templateContext 模板内容
     * @return DubboResult
     */
    DubboResult<Void> addTemplate(String templateCode, String templateName, String templateContext,String noteTemplateId,String smsType);
    
    /**
     * 更新模板内容
     *
     * @author zhanglihui
     * @param id
     * @param templateContext
     * @return DubboResult
     */
    DubboResult<Void> updateTemplate(Long id, String templateContext,String noteTemplateId,String smsType);
    
    /**
     * 查询模板列表
     *
     * @author zhanglihui
     * @return List<TemplateDto>
     */
    DubboResult<List<TemplateDto>> findTemplateList();

    /**
     * 根据模板代码查询模板内容
     *
     * @author zhanglihui
     * @param templateCode
     * @return 模板内容
     */
    TemplateDto findByCode(String templateCode);
}

