/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

public enum LogisticsOrderStatusEnum {
    ACCEPT("ACCEPT", "\u63a5\u5355"),
    UNDER_WAY("UNDER_WAY", "\u5728\u9014"),
    SENT_SCAN("SENT_SCAN", "\u6d3e\u4ef6"),
    SUCCESS("SUCCESS", "\u7b7e\u6536\u6210\u529f"),
    FAILED("FAILED", "\u7b7e\u6536\u5931\u8d25"),
    RETURN("RETURN", "\u9000\u4ef6\u6210\u529f"),
    SEND_BACK("SEND_BACK", "\u9000\u56de\u4e2d"),
    REJECTED("REJECTED", "\u62d2\u7b7e");

    private String code;
    private String desc;

    private LogisticsOrderStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static LogisticsOrderStatusEnum getByCode(String code) {
        for (LogisticsOrderStatusEnum enumVal : LogisticsOrderStatusEnum.values()) {
            if (!StringUtils.equals((String)code, (String)enumVal.getCode())) continue;
            return enumVal;
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static String getRemarkByLogisticsStatus(LogisticsOrderStatusEnum status) {
        String remark = "";
        if (status == null) {
            return remark;
        }
        switch (status) {
            case ACCEPT: {
                remark = "\u63a5\u5355";
                break;
            }
            case UNDER_WAY: {
                remark = "\u5728\u9014";
                break;
            }
            case SENT_SCAN: {
                remark = "\u6d3e\u4ef6";
                break;
            }
            case SUCCESS: {
                remark = "\u7b7e\u6536\u6210\u529f";
                break;
            }
            case FAILED: {
                remark = "\u7b7e\u6536\u5931\u8d25";
                break;
            }
            case RETURN: {
                remark = "\u9000\u4ef6\u6210\u529f";
                break;
            }
            case REJECTED: {
                remark = "\u62d2\u7b7e";
                break;
            }
            case SEND_BACK: {
                remark = "\u9000\u56de\u4e2d";
                break;
            }
        }
        return remark;
    }
}

