package com.qiho.center.api.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by liuyao on 2017/6/3.
 * 资金状态
 */
public enum FundStatusEnum {

    TO_PAY("TO_PAY","待付款"),
    SUCCESS("SUCCESS","付款成功"),
    FAILED("FAILED","付款失败");

     /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private static Map<String,FundStatusEnum> enumMap = Maps.newHashMap();
    static {
        for(FundStatusEnum it:FundStatusEnum.values()){
            enumMap.put(it.code,it);
        }
    }

    public static FundStatusEnum getEnumByCode(String code){
        return enumMap.get(code);
    }

    private FundStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
