package com.qiho.center.api.params.account;

import java.io.Serializable;

/**
 * @author Wangpf
 * @description 百奇账号保存参数 和dto区分开
 * @date 2020/4/21 11:04 PM
 */
public class BaiqiAccountSaveParam implements Serializable {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 账户名称
     */
    private String account;

    /**
     * 账户类型 @See BaiqiAccountTypeEnum
     */
    private Integer accountType;

    /**
     * 主账号id
     */
    private Long parentId;

    /**
     * 密码
     */
    private String pwd;

    /**
     * 账户状态 @See BaiqiAccountStatusEnum
     */
    private Integer state;

    /**
     * 子账号菜单id集
     */
    private String menuIds;

    /**
     * 商家版本
     */
    private String versionSign;

    /**
     * 关联的商家/代理商ID
     */
    private String relationId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getPwd() {
        return pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getMenuIds() {
        return menuIds;
    }

    public void setMenuIds(String menuIds) {
        this.menuIds = menuIds;
    }

    public String getVersionSign() {
        return versionSign;
    }

    public void setVersionSign(String versionSign) {
        this.versionSign = versionSign;
    }

    public String getRelationId() {
        return relationId;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
    }
}
