package com.qiho.center.api.remoteservice.account;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.account.BaiqiAccountDto;
import com.qiho.center.api.params.account.BaiqiAccountSaveParam;

import java.util.List;

/**
 * 子账号管理
 *
 * @author peanut.huang
 * @date 2017/12/8.
 */
@AdvancedFeignClient
public interface RemoteSubAccountService {


    /**
     * 查询归属主账号下的子账号(子账号属性不包含权限列表)
     *
     * @param parentId  主账号id
     * @return
     */
    List<BaiqiAccountDto> findByParentId(Long parentId);

    /**
     * 子账号生效
     *
     * @param subAid  子账号id
     * @return
     */
    Boolean enable(Long subAid);

    /**
     * 子账号关闭
     *
     * @param subAid 子账号id
     * @return
     */
    Boolean disable(Long subAid);

    /**
     * 删除子账号
     *
     * a、账号删除
     * b、删除账号权限关系
     *
     * @param subAid  子账号id
     * @return
     */
    Boolean delete(Long subAid);

    /**
     * 保存子账号
     *
     * @param baiqiAccountSaveParam
     * @return
     * @throws BizException   当账号名称或手机号已存在时抛出
     */
    Boolean save(BaiqiAccountSaveParam baiqiAccountSaveParam) throws BizException;

    /**
     * 子账号查询实体
     *
     * @param subAid 子账号id
     * @return
     */
    BaiqiAccountDto findById(Long subAid);
}
