package com.qiho.center.api.remoteservice.sms;

import com.qiho.center.api.dto.sms.ChuangLanSmsCommitDto;
import com.qiho.center.api.dto.sms.ChuangLanSmsReportDto;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * Created by weny.cai on 2018/4/20.
 */
@AdvancedFeignClient
public interface RemoteChuangLanService {

    ChuangLanSmsCommitDto selectByMsgId(String msgId);

    void reportHandler(ChuangLanSmsReportDto dto);

    /**
     * 创蓝发送短信
     *
     * @param mobile        手机号
     * @param templateCode  短信模板值{@link SmsTemplateEnum#code}
     * @param fillCode      填充模板内容的值
     * @return              发送成功/失败
     * @throws BizException
     */
    boolean sendMsg(String mobile, String templateCode, String fillCode) throws BizException;

}
