package com.qiho.center.api.util;

import com.qiho.center.api.constant.ChuangLanConstant;
import com.qiho.center.api.enums.ordersms.SmsMobileStatusEnum;

/**
 * 下单短信的工具类
 * @author chensong
 * @create 2018-05-18 17:13
 **/
public class OrderSmsUtil {

    private OrderSmsUtil(){

    }

    /**
     * 创蓝的返回码映射成百奇的返回码
     * @param status
     * @return
     */
    public static SmsMobileStatusEnum getReturnCodeByChuangLanStatus(String status){
        SmsMobileStatusEnum baiqiCode ;
        if(status.equals("ERRNUM")||status.equals("SGIP:1")||status.equals("MN:0001")
                ||status.equals("MK:0001")||status.equals("CB:0001")||status.equals("6640")
                ||status.equals("0006")||status.equals("XL:169")||status.equals("1")||
                status.equals("10")||status.equals("67")||status.equals("61")||status.equals("72")||
                status.equals("101")||status.equals("-1")||status.equals("RP:1")||
                status.equals("Deliver")||status.equals("LT:0001")){
            baiqiCode = SmsMobileStatusEnum.EMPTY_NUM;
        }else if(status.equals("MBBLACK")){
            baiqiCode = SmsMobileStatusEnum.BLACKLIST;
        }else if(status.startsWith("MK")||status.startsWith("MI")||status.startsWith("MN")||
                status.startsWith("SGIP")||status.startsWith("UNDELIV")||status.startsWith("CU")||
                status.startsWith("RP:")||
                status.equals("0005")||status.equals("IB:0064")||status.equals("4") ||status.equals("54")||
                status.equals("51")||status.equals("-37")||status.equals("53")||
                status.equals("4716")||status.equals("0007")||status.equals("5")||status.equals("50")||
                status.equals("45")||status.equals("36")||status.equals("56") ||status.equals("213")||
                status.equals("ID:0102")||status.equals("SPMSERR:102")){
            baiqiCode = SmsMobileStatusEnum.CLOSE_DOWN;
        }else if(status.equals("DELIVRD")){
            baiqiCode = SmsMobileStatusEnum.SUCCESS;
        }else {
            baiqiCode = SmsMobileStatusEnum.UNKNOWN;
        }
        return baiqiCode;
    }





}
